/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.examples;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeVisitor;

public class HtmlToPlainText {
    private static final String userAgent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 (jsoup-example)";
    private static final int timeout = 5000;

    public static void main(String ... args) throws IOException {
        Validate.isTrue(args.length == 1 || args.length == 2, "usage: java -jar jsoup-examples.jar url [selector]");
        String url = args[0];
        String selector = args.length == 2 ? args[1] : null;
        Connection session = Jsoup.newSession().userAgent(userAgent).timeout(5000);
        Document doc = session.newRequest(url).get();
        if (selector != null) {
            Elements elements = doc.select(selector);
            elements = HtmlToPlainText.trimParents(elements);
            for (Element element : elements) {
                String plainText = HtmlToPlainText.getPlainText(element);
                System.out.println(plainText);
            }
        } else {
            String plainText = HtmlToPlainText.getPlainText(doc);
            System.out.println(plainText);
        }
    }

    static String getPlainText(Element element) {
        FormattingVisitor formatter = new FormattingVisitor();
        formatter.traverse(element);
        return formatter.toString();
    }

    static Elements trimParents(Elements elements) {
        HashSet<Element> seen = new HashSet<Element>(elements.size());
        Elements trimmed = new Elements();
        Iterator iterator = elements.iterator();
        block0: while (iterator.hasNext()) {
            Element el;
            Element current = el = (Element)iterator.next();
            while (current.parent() != null) {
                if (seen.contains(current.parent())) continue block0;
                current = current.parent();
            }
            seen.add(el);
            trimmed.add(el);
        }
        return trimmed;
    }

    private static class FormattingVisitor
    implements NodeVisitor {
        private static final int maxWidth = 80;
        private int width = 0;
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        @Override
        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name.equals("li")) {
                this.append("\n * ");
            } else if (name.equals("dt")) {
                this.append("  ");
            } else if (StringUtil.in(name, "p", "h1", "h2", "h3", "h4", "h5", "tr")) {
                this.append("\n");
            }
        }

        @Override
        public void tail(Node node, int depth) {
            String name = node.nodeName();
            if (StringUtil.in(name, "br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5")) {
                this.append("\n");
            } else if (name.equals("a")) {
                this.append(String.format(" <%s>", node.absUrl("href")));
            }
        }

        private void append(String text) {
            if (text.startsWith("\n")) {
                this.width = 0;
            }
            if (text.equals(" ") && (this.accum.length() == 0 || StringUtil.in(this.accum.substring(this.accum.length() - 1), " ", "\n"))) {
                return;
            }
            if (text.length() + this.width > 80) {
                String[] words = text.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    boolean last;
                    String word = words[i];
                    boolean bl = last = i == words.length - 1;
                    if (!last) {
                        word = word + " ";
                    }
                    if (word.length() + this.width > 80) {
                        this.accum.append("\n").append(word);
                        this.width = word.length();
                        continue;
                    }
                    this.accum.append(word);
                    this.width += word.length();
                }
            } else {
                this.accum.append(text);
                this.width += text.length();
            }
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

